using System;
using System.Collections.Generic;
using System.Linq;

public class Program
{
    private class Move
    {
        public long Z { get; set; }
        public long Y { get; set; }
        public int Index { get; set; }
    }

    private class Result
    {
        public long XFinal { get; set; }
        public long YFinal { get; set; }
        public long SquaredDistance { get; set; }
        public List<int> Indices { get; set; }
    }

    private static Result SolveCase(List<Move> allMoves, Func<Move, bool> selectionRule)
    {
        long xFinal = 0;
        long yFinal = 0;
        List<int> selectedIndices = new List<int>();

        foreach (var move in allMoves)
        {
            if (selectionRule(move))
            {
                xFinal += move.Z;
                yFinal += move.Y;
                selectedIndices.Add(move.Index);
            }
        }

        // ??????? ????????? ??????????: X^2 + Y^2
        long squaredDistance = xFinal * xFinal + yFinal * yFinal;

        return new Result
        {
            XFinal = xFinal,
            YFinal = yFinal,
            SquaredDistance = squaredDistance,
            Indices = selectedIndices.OrderBy(i => i).ToList()
        };
    }

    public static void Main(string[] args)
    {
        // ?????? N (?????????? ????????? ???????????)
        if (!int.TryParse(Console.ReadLine(), out int n))
        {
            return;
        }

        List<Move> allMoves = new List<Move>();
        for (int i = 1; i <= n; i++)
        {
            string line = Console.ReadLine();
            if (string.IsNullOrEmpty(line)) continue;
            string[] parts = line.Split(new char[] { ' ', '\t' }, StringSplitOptions.RemoveEmptyEntries);

            if (parts.Length == 2 && long.TryParse(parts[0], out long z) && long.TryParse(parts[1], out long y))
            {
                allMoves.Add(new Move { Z = z, Y = y, Index = i });
            }
        }

        // ??????? 4 ???????? ????????? ?????? (???????????? 4 ?????????? ??? ????????? ???????)
        // ??? 4 ??????, ????????, ????????? 4 ????????????? ??????,
        // ??? ?? ????? ??????????????? X ? Y, -X ? Y, X ? -Y, -X ? -Y.

        // ????????? 1: X >= 0, Y >= 0. ????????, ???? Z > 0 ? Y > 0.
        // ????? ????????: ????????, ???? Z > 0 ??? Y > 0, ?? ??? ???????.
        // ?????????? ?????????????: ????????, ???? Z > 0, ??? Y > 0, ??? Z = 0 ? Y = 0 (???? ??? ???????).

        // ?????????? 4 ??????? ?????? ??????:
        // Set 1: Maximize X and Maximize Y
        var result1 = SolveCase(allMoves, m => m.Z >= 0 && m.Y >= 0);

        // Set 2: Minimize X and Maximize Y (equivalent to Maximize -X and Maximize Y)
        var result2 = SolveCase(allMoves, m => m.Z <= 0 && m.Y >= 0);

        // Set 3: Maximize X and Minimize Y (equivalent to Maximize X and Maximize -Y)
        var result3 = SolveCase(allMoves, m => m.Z >= 0 && m.Y <= 0);

        // Set 4: Minimize X and Minimize Y (equivalent to Maximize -X and Maximize -Y)
        var result4 = SolveCase(allMoves, m => m.Z <= 0 && m.Y <= 0);

        // ????????? ???????????
        Result bestResult = result1;

        if (result2.SquaredDistance > bestResult.SquaredDistance) bestResult = result2;
        if (result3.SquaredDistance > bestResult.SquaredDistance) bestResult = result3;
        if (result4.SquaredDistance > bestResult.SquaredDistance) bestResult = result4;

        // ????? ????????? ?????? ????? (D^2 = 0)
        if (bestResult.SquaredDistance == 0)
        {
             // ???? ?????? ????? ???? 0, ? ?????-?? ?????? ????? ???? 0,
             // ????? ??????? ????? ?????. ?? ??? ??????? ????.
        }

        // ????? ??????????
        Console.WriteLine(bestResult.Indices.Count);
        if (bestResult.Indices.Count > 0)
        {
            Console.WriteLine(string.Join(" ", bestResult.Indices));
        }
    }
}